package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext6
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum Ext6 {

    _1("1", "oa"),
    _2("2", "cms5"),
    _3("3", "cms6");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ext6(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext6 fromCode(String code) {
        return Stream.of(Ext6.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
