package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext8_wilmar
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum Ext8Wilmar {

    _1("1", "EPM"),
    _2("2", "每刻"),
    _3("3", "SAP");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ext8Wilmar(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext8Wilmar fromCode(String code) {
        return Stream.of(Ext8Wilmar.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
