package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext_gmry
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum ExtGMRY {

    _584("584", "股份公司总部"),
    _622("622", "上海社区部"),
    _599("599", "学生奶事业部"),
    _255("255", "奶粉事业部"),
    _254("254", "UHT事业部"),
    _6382("6382", "中央工厂"),
    _7944("7944", "华东中心工厂"),
    _2502("2502", "华东生产总部"),
    _11765("11765", "电商营销中心"),
    _8745("8745", "研究院"),
    _631("631", "乳品二厂"),
    _641("641", "上海商超部"),
    _646("646", "酸奶事业部八厂");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExtGMRY(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExtGMRY fromCode(String code) {
        return Stream.of(ExtGMRY.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
