package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_checked_tab_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum InvoiceCheckedTabFlag {

    已勾选("已勾选", "已勾选"),
    已认证("已认证", "已认证"),
    已转出("已转出", "已转出");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceCheckedTabFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceCheckedTabFlag fromCode(String code) {
        return Stream.of(InvoiceCheckedTabFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
