package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_drawback_check_tab_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum InvoiceDrawbackCheckTabFlag {

    可勾选("可勾选", "可勾选"),
    配置拦截("配置拦截", "配置拦截"),
    不可勾选("不可勾选", "不可勾选");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceDrawbackCheckTabFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceDrawbackCheckTabFlag fromCode(String code) {
        return Stream.of(InvoiceDrawbackCheckTabFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
