package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_orig
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum InvoiceOrig {

    _1("1", "验真"),
    _2("2", "底账"),
    _3("3", "协同直连"),
    _4("4", "协同抽取"),
    _5("5", "协同手工回填"),
    _6("6", "影像识别"),
    _7("7", "票税助手"),
    _8("8", "接口上传"),
    _9("9", "无"),
    _10("10", "农产品"),
    _11("11", "文件导入"),
    _12("12", "进项发票归集"),
    _13("13", "农产品加计扣除"),
    _14("14", "销项发票归集");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceOrig(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceOrig fromCode(String code) {
        return Stream.of(InvoiceOrig.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
