package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_open
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum IsOpen {

    _0("0", "已失效"),
    _1("1", "正常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsOpen(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsOpen fromCode(String code) {
        return Stream.of(IsOpen.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
