package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * match_style
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum MatchStyle {

    _0("0", "自动"),
    _1("1", "手动"),
    _2("2", "强制");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchStyle(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchStyle fromCode(String code) {
        return Stream.of(MatchStyle.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
