package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pur_company_exception_content
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum PurCompanyExceptionContent {

    _1("1", "抬头不一致"),
    _2("2", "地址电话不一致"),
    _3("3", "银行信息不一致"),
    _4("4", "公司信息未维护"),
    _5("5", "验真人没有发票权限"),
    _0("0", "未知");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PurCompanyExceptionContent(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PurCompanyExceptionContent fromCode(String code) {
        return Stream.of(PurCompanyExceptionContent.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
