package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * special_invoice_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum SpecialInvoiceFlag {

    _0("0", "无"),
    _1("1", "通行费"),
    _2("2", "成品油"),
    _3("3", "区块链"),
    _5("5", "建筑服务"),
    _6("6", "货物运输服务"),
    _7("7", "不动产销售"),
    _8("8", "不动产经营租赁服务"),
    _9("9", "农产品销售"),
    _10("10", "农产品收购"),
    _11("11", "稀土"),
    _12("12", "通行费可抵扣"),
    _13("13", "通行费不可抵扣"),
    _14("14", "旅客运输服务"),
    _15("15", "机动车"),
    _16("16", "代征车船税"),
    _17("17", "医疗服务（住院）"),
    _18("18", "医疗服务（门诊）"),
    _19("19", "拖拉机和联合收割机"),
    _20("20", "二手车"),
    _21("21", "光伏收购"),
    _22("22", "卷烟"),
    _23("23", "出口"),
    _24("24", "农产品"),
    _25("25", "火车票"),
    _26("26", "航空运输电子客票行程单"),
    _27("27", "自产农产品销售"),
    _28("28", "差额征税-差额开票"),
    _29("29", "差额征税-全额开票"),
    _30("30", "白酒"),
    _31("31", "报废产品收购"),
    _32("32", "二手车*"),
    _51("51", "二手车销售统一发票（正向开具）"),
    _52("52", "二手车销售统一发票（反向开具）"),
    _33("33", "矿产品");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SpecialInvoiceFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SpecialInvoiceFlag fromCode(String code) {
        return Stream.of(SpecialInvoiceFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
