package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * system_source
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum SystemSource {

    _0("0", "招采"),
    _1("1", "易快报");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SystemSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SystemSource fromCode(String code) {
        return Stream.of(SystemSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
