package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * turn_out_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-23
 */
public enum TurnOutStatus {

    _0("0", "未转出"),
    _1("1", "部分转出"),
    _2("2", "已转出");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TurnOutStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TurnOutStatus fromCode(String code) {
        return Stream.of(TurnOutStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
