package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auth_style
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum AuthStyle {

    _0("0", "无"),
    _10("10", "页面手工勾选"),
    _11("11", "外部接口勾选"),
    _12("12", "国税底账勾选"),
    _13("13", "系统自动勾选"),
    _14("14", "文件导入勾选"),
    _21("21", "平台取消勾选"),
    _22("22", "国税取消勾选"),
    _15("15", "手工修改勾选"),
    _31("31", "票易通传统认证"),
    _32("32", "非票易通体外导入传统认证"),
    _33("33", "非票易通传统认证"),
    _34("34", "非票易通退税确认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuthStyle(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStyle fromCode(String code) {
        return Stream.of(AuthStyle.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
