package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_tag1_jkl
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum BizTag1JKL {

    _1("1", "结算中心"),
    _2("2", "费用"),
    结算中心("结算中心", "结算中心"),
    集团总部("集团总部", "集团总部"),
    生鲜配送("生鲜配送", "生鲜配送"),
    便利店("便利店", "便利店"),
    首超("首超", "首超"),
    通州("通州", "通州");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BizTag1JKL(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizTag1JKL fromCode(String code) {
        return Stream.of(BizTag1JKL.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
