package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * exception_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum ExceptionStatus {

    _0("0", "正常"),
    _1("1", "异常"),
    _2("2", "预警");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExceptionStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExceptionStatus fromCode(String code) {
        return Stream.of(ExceptionStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
