package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext19_wilmar
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum Ext19Wilmar {

    _0("0", "采购类"),
    _1("1", "银行类"),
    _2("2", "其他类"),
    _3("3", "费用类");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ext19Wilmar(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext19Wilmar fromCode(String code) {
        return Stream.of(Ext19Wilmar.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
