package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext26
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum Ext26 {

    非服务("非服务", "非服务"),
    服务("服务", "服务");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ext26(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext26 fromCode(String code) {
        return Stream.of(Ext26.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
