package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext3_wilmar
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum Ext3Wilmar {

    _0("0", "无需审批"),
    _1("1", "审批中"),
    _2("2", "审批通过"),
    _3("3", "审批不通过");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ext3Wilmar(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext3Wilmar fromCode(String code) {
        return Stream.of(Ext3Wilmar.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
