package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * file_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum FileType {

    _0("0", "无"),
    JPG("jpg", "jpg"),
    PNG("png", "png"),
    PDF("pdf", "pdf"),
    OFD("ofd", "ofd"),
    JPEG("jpeg", "jpeg"),
    XML("xml", "xml");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FileType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileType fromCode(String code) {
        return Stream.of(FileType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
