package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * function_code
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum FunctionCode {

    _1("1", "一税号多租户组织"),
    _2("2", "底账同步自动触发验真"),
    _3("3", "验真失败补偿"),
    _4("4", "备注解析单号"),
    _5("5", "下发字段映射"),
    _6("6", "电子影像租户定制字段"),
    _7("7", "发票源文件推送电子影像"),
    _8("8", "底账同步自动触发取消配单"),
    _9("9", "发票不合规校验"),
    _10("10", "接收发票数据字段转换"),
    _11("11", "协同开票数据过滤配置"),
    _12("12", "迁移4.0数据字段映射"),
    _13("13", "openapi发票查询接口支持查询参数配置"),
    _14("14", "税件归集来源数据验真状态配置"),
    _15("15", "openapi业务单更新接口支持参数配置"),
    _16("16", "openapi业务单更新参数是否继承到发票"),
    _17("17", "影像地址转换"),
    _18("18", "基于税号过滤发票数据"),
    _19("19", "租户税号公司编号映射配置"),
    _20("20", "税件归集来源数据识别状态配置"),
    _21("21", "发票取消入账"),
    _22("22", "归集发票源文件同步至电子影像配置"),
    _23("23", "底账未获取税号邮箱配置"),
    _24("24", "字段优先级配置"),
    _25("25", "是否删除发票明细"),
    _26("26", "配单下发配置"),
    _27("27", "是否开启触发经营非经营性判断"),
    _28("28", "老风险发票开启配置"),
    _29("29", "业务配置字段条件组集合"),
    _30("30", "单据上传是否开启自动找票"),
    _31("31", "单据上传是否开启拆词"),
    _32("32", "发票上传是否开启拆词");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FunctionCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FunctionCode fromCode(String code) {
        return Stream.of(FunctionCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
