package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_offline_check_tab_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum InvoiceOfflineCheckTabFlag {

    可勾选("可勾选", "可勾选"),
    已认证("已认证", "已认证");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceOfflineCheckTabFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceOfflineCheckTabFlag fromCode(String code) {
        return Stream.of(InvoiceOfflineCheckTabFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
