package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * match_data_source
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum MatchDataSource {

    _0("0", "老配单"),
    _1("1", "新业务单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchDataSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchDataSource fromCode(String code) {
        return Stream.of(MatchDataSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
