package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ncp_jjkc_auth_use
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum NcpJjkcAuthUse {

    _0("0", "未加计"),
    _2("2", "不用于加计"),
    _3("3", "用于加计");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NcpJjkcAuthUse(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NcpJjkcAuthUse fromCode(String code) {
        return Stream.of(NcpJjkcAuthUse.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
