package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * report_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum ReportStatus {

    _0("0", "未报账"),
    _1("1", "已报账"),
    _2("2", "取消报账");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReportStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReportStatus fromCode(String code) {
        return Stream.of(ReportStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
