package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * satisfy
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum Satisfy {

    _0("0", "不满足"),
    _1("1", "满足"),
    _9("9", "未知");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Satisfy(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Satisfy fromCode(String code) {
        return Stream.of(Satisfy.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
