package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * send_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum SendStatus {

    _1("1", "发送成功"),
    _2("2", "发送失败"),
    _0("0", "未发送");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SendStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SendStatus fromCode(String code) {
        return Stream.of(SendStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
