package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sense_word_level
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum SenseWordLevel {

    _0("0", "弱控"),
    _1("1", "强控"),
    _2("2", "无");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SenseWordLevel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SenseWordLevel fromCode(String code) {
        return Stream.of(SenseWordLevel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
