package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * transfer_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum TransferStatus {

    _0("0", "未知"),
    _1("1", "应转出"),
    _2("2", "已转出");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TransferStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TransferStatus fromCode(String code) {
        return Stream.of(TransferStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
