package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * travel_ticket_item
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TravelTicketItem implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 行号
   */
  private Long rowNum;
  /**
   * 始发站
   */
  private String from;
  /**
   * 目的站
   */
  private String to;
  /**
   * 承运人
   */
  private String carrier;
  /**
   * 航班号
   */
  private String flightNo;
  /**
   * 座位等级
   */
  private String classOfService;
  /**
   * 承运日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime carrierDate;
  /**
   * 客票级别
   */
  private String fareBasis;
  /**
   * 客票生效日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime effectiveDate;
  /**
   * 有效截止日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deadline;
  /**
   * 免费行李
   */
  private String freeWeight;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 起飞时间
   */
  private String departureTime;
  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 对一关联关系 关联对象 travelTicket
   */
  private Long travelItemAndTravelRelationId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("invoice_no", invoiceNo);
      map.put("row_num", rowNum);
      map.put("from", from);
      map.put("to", to);
      map.put("carrier", carrier);
      map.put("flight_no", flightNo);
      map.put("class_of_service", classOfService);
      map.put("carrier_date", BocpGenUtils.toTimestamp(carrierDate));
      map.put("fare_basis", fareBasis);
      map.put("effective_date", BocpGenUtils.toTimestamp(effectiveDate));
      map.put("deadline", BocpGenUtils.toTimestamp(deadline));
      map.put("free_weight", freeWeight);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("departure_time", departureTime);
      map.put("org_tree", orgTree);

      map.put("travelItemAndTravelRelation.id", travelItemAndTravelRelationId);
      return map;
  }

  public static TravelTicketItem fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    TravelTicketItem entity = new TravelTicketItem();

    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("row_num")) {
      Object obj = map.get("row_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRowNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRowNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRowNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("from")) {
      Object obj = map.get("from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("to")) {
      Object obj = map.get("to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("carrier")) {
      Object obj = map.get("carrier");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCarrier((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flight_no")) {
      Object obj = map.get("flight_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlightNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("class_of_service")) {
      Object obj = map.get("class_of_service");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClassOfService((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("carrier_date")) {
      Object obj = map.get("carrier_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCarrierDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCarrierDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCarrierDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCarrierDate(null);
      }
    }
    if(map.containsKey("fare_basis")) {
      Object obj = map.get("fare_basis");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFareBasis((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effective_date")) {
      Object obj = map.get("effective_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEffectiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEffectiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEffectiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEffectiveDate(null);
      }
    }
    if(map.containsKey("deadline")) {
      Object obj = map.get("deadline");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeadline(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeadline((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeadline(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeadline(null);
      }
    }
    if(map.containsKey("free_weight")) {
      Object obj = map.get("free_weight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFreeWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departure_time")) {
      Object obj = map.get("departure_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDepartureTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("travelItemAndTravelRelation.id")) {
       Object obj = map.get("travelItemAndTravelRelation.id");
       if(obj instanceof Long) {
         entity.setTravelItemAndTravelRelationId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setTravelItemAndTravelRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("row_num")) {
      Object obj = map.get("row_num");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRowNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRowNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setRowNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("from")) {
      Object obj = map.get("from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("to")) {
      Object obj = map.get("to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("carrier")) {
      Object obj = map.get("carrier");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCarrier((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flight_no")) {
      Object obj = map.get("flight_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFlightNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("class_of_service")) {
      Object obj = map.get("class_of_service");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setClassOfService((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("carrier_date")) {
      Object obj = map.get("carrier_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCarrierDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCarrierDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCarrierDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCarrierDate(null);
      }
    }
    if(map.containsKey("fare_basis")) {
      Object obj = map.get("fare_basis");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFareBasis((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effective_date")) {
      Object obj = map.get("effective_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEffectiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setEffectiveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEffectiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setEffectiveDate(null);
      }
    }
    if(map.containsKey("deadline")) {
      Object obj = map.get("deadline");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDeadline(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDeadline((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeadline(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDeadline(null);
      }
    }
    if(map.containsKey("free_weight")) {
      Object obj = map.get("free_weight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFreeWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departure_time")) {
      Object obj = map.get("departure_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDepartureTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgTree((String)obj);
        }
      } else{
      }
    }
  if(map.containsKey("travelItemAndTravelRelation.id")) {
    Object obj = map.get("travelItemAndTravelRelation.id");
    if(obj instanceof Long) {
        this.setTravelItemAndTravelRelationId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setTravelItemAndTravelRelationId(Long.parseLong((String)obj));
    }
  }
  }
}
