package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * area_unit
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum AreaUnit {

    _01("01", "平方米"),
    _02("02", "亩"),
    _03("03", "㎡"),
    _04("04", "平方千米"),
    _05("05", "公顷"),
    _06("06", "h㎡"),
    _07("07", "k㎡");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AreaUnit(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AreaUnit fromCode(String code) {
        return Stream.of(AreaUnit.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
