package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_makeout_status
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum BizMakeoutStatus {

    _0("0", "未开票"),
    _1("1", "开票中"),
    _2("2", "已开票"),
    _3("3", "已生成预制发票"),
    _4("4", "部分未提交+部分已生成预制发票"),
    _5("5", "部分未提交+部分已开票"),
    _6("6", "部分已生成预制发票+部分已开票"),
    _7("7", "部分未提交+部分已生成预制发票+部分已开票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BizMakeoutStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizMakeoutStatus fromCode(String code) {
        return Stream.of(BizMakeoutStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
