package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_tag_mcdonalds
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum BusinessTagMcdonalds {

    AP("AP", "AP"),
    GL("GL", "GL"),
    _("-", "-");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessTagMcdonalds(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessTagMcdonalds fromCode(String code) {
        return Stream.of(BusinessTagMcdonalds.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
