package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext17_wilmar
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum Ext17Wilmar {

    _0("0", "正常第三方"),
    _1("1", "关联方非买断发票"),
    _2("2", "关联方买断发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ext17Wilmar(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext17Wilmar fromCode(String code) {
        return Stream.of(Ext17Wilmar.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
