package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext4
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum Ext4 {

    _1("1", "进货发票"),
    _2("2", "退货发票"),
    _3("3", "返利发票"),
    _4("4", "转税率发票"),
    _5("5", "调账发票"),
    _6("6", "进口类发票"),
    _7("7", "虚拟发票"),
    _8("8", "物流退款发票"),
    _9("9", "转仓发票"),
    _10("10", "费用发票"),
    _11("11", "退货-转税率发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ext4(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext4 fromCode(String code) {
        return Stream.of(Ext4.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
