package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext9_wilmar
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum Ext9Wilmar {

    CC("CC", "CC-进项税，11%，货物（应税不可分-3900007）"),
    P2("P2", "P2-进项税，6%（3900005"),
    P5("P5", "P5-进项税，17%（3900005）"),
    F1("F1", "F1-进项税，13%（3900005）"),
    F2("F2", "F2-进项税，13%（应税不可分-3900007）"),
    E1("E1", "E1-进项税，9%，货物（增税票可分-3900005）"),
    F3("F3", "F3-进项税，13%（免税项目-3900008）"),
    E2("E2", "E2-进项税，9%，货物（应税不可分-3900007）"),
    D1("D1", "D1-进项税，16%（3900005）"),
    D2("D2", "D2-进项税，16%（应税不可分-3900007）"),
    D3("D3", "D3-进项税，16%（免税项目-3900008）"),
    A1("A1", "A1-进项税，10%，货物（增税票可分-3900005）"),
    E6("E6", "E6-进项税，9%，适用核定扣除（农产品采购税金-应税项目-3000106）"),
    A2("A2", "A2-进项税，10%，货物（应税不可分-3900007）"),
    E7("E7", "E7-进项税，9%，适作核定扣除（农产品采购税金-不可分-3000107）"),
    PC("PC", "PC-进项税，17%（应税不可分-3900007）"),
    ZN("ZN", "ZN-进项税，1%，小规模纳税人进项税（应税可分-3900005）"),
    A6("A6", "A6-进项税，10%，适用核定扣除（农产品采购税金-应税项目-3000106）"),
    ZP("ZP", "ZP-进项税，1%，小规模纳税人进项税（应税不可分-3900007）"),
    A7("A7", "A7-进项税，10%，适作核定扣除（农产品采购税金-不可分-3000107）"),
    ZQ("ZQ", "ZQ-进项税，1%，小规模纳税人进项税（免税及非应税-3900008）"),
    CB("CB", "CB-进项税，11%，货物（增税票可分-3900005）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ext9Wilmar(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext9Wilmar fromCode(String code) {
        return Stream.of(Ext9Wilmar.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
