package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_category
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum InvoiceCategory {

    A("A", "扫描发票"),
    B("B", "扫描无订单发票"),
    C("C", "发票扫描导入"),
    D("D", "非增值税发票"),
    EXPENSES_BILL("expensesBill", "费报发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceCategory fromCode(String code) {
        return Stream.of(InvoiceCategory.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
