package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_color
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum InvoiceColor {

    _1("1", "蓝字发票"),
    _2("2", "红字发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceColor(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceColor fromCode(String code) {
        return Stream.of(InvoiceColor.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
