package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_check
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum IsCheck {

    _0("0", "未勾选"),
    _1("1", "已勾选"),
    _2("2", "已确认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsCheck(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsCheck fromCode(String code) {
        return Stream.of(IsCheck.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
