package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_need_auth
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum IsNeedAuth {

    _0("0", "否"),
    _1("1", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsNeedAuth(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsNeedAuth fromCode(String code) {
        return Stream.of(IsNeedAuth.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
