package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * no_compliance_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum NoComplianceFlag {

    _1("1", "发票主信息"),
    _2("2", "发票明细信息");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NoComplianceFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoComplianceFlag fromCode(String code) {
        return Stream.of(NoComplianceFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
