package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * origin_file_type
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum OriginFileType {

    _0("0", "--"),
    PDF("pdf", "pdf"),
    OFD("ofd", "ofd"),
    XML("xml", "xml");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OriginFileType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OriginFileType fromCode(String code) {
        return Stream.of(OriginFileType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
