package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * price_method
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum PriceMethod {

    _0("0", "不含税方式"),
    _1("1", "含税方式");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PriceMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PriceMethod fromCode(String code) {
        return Stream.of(PriceMethod.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
