package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * recog_status
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum RecogStatus {

    _0("0", "未识别"),
    _1("1", "已识别");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RecogStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecogStatus fromCode(String code) {
        return Stream.of(RecogStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
