package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * return_type
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum ReturnType {

    _1("1", "发票票面有误"),
    _2("2", "发票审核错误"),
    _3("3", "产值有误"),
    _4("4", "产值红冲"),
    _5("5", "邮寄错误"),
    _6("6", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReturnType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReturnType fromCode(String code) {
        return Stream.of(ReturnType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
