package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * standard
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum Standard {

    _0("0", "标准"),
    _1("1", "定制");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Standard(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Standard fromCode(String code) {
        return Stream.of(Standard.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
