package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_rate_definition
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum TaxRateDefinition {

    _0("0", "0%"),
    _3("3", "3%"),
    _5("5", "5%"),
    _6("6", "6%"),
    _9("9", "9%"),
    _11("11", "11%"),
    _13("13", "13%"),
    _16("16", "16%"),
    _17("17", "17%"),
    _1("1", "1%"),
    _1_5("1.5", "1.5%"),
    _10("10", "10%");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxRateDefinition(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxRateDefinition fromCode(String code) {
        return Stream.of(TaxRateDefinition.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
