package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * verify_status
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public enum VerifyStatus {

    _0("0", "未验真"),
    _1("1", "验真失败"),
    _2("2", "验真中"),
    _3("3", "验真成功"),
    _4("4", "无需验真");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VerifyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VerifyStatus fromCode(String code) {
        return Stream.of(VerifyStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
