package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.validator;

import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2025-11-03
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(IssueFlag.class)) {
            isValid = null != IssueFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IssueFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialInvoiceFlag.class)) {
            isValid = null != SpecialInvoiceFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SpecialInvoiceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SaleListFlag.class)) {
            isValid = null != SaleListFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SaleListFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogStatus.class)) {
            isValid = null != RecogStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecogStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogSheet.class)) {
            isValid = null != RecogSheet.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecogSheet.class.getSimpleName());
            }
        }
        if(clazz.equals(FileType.class)) {
            isValid = null != FileType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FileType.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyStatus.class)) {
            isValid = null != VerifyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VerifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifySignStatus.class)) {
            isValid = null != VerifySignStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VerifySignStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStyle.class)) {
            isValid = null != AuthStyle.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStyle.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthUse.class)) {
            isValid = null != AuthUse.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = null != AuthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoAuthReason.class)) {
            isValid = null != NoAuthReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoAuthReason.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceOrig.class)) {
            isValid = null != InvoiceOrig.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceOrig.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag.class)) {
            isValid = null != CooperateFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CooperateFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ComplianceStatus.class)) {
            isValid = null != ComplianceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ComplianceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RetreatStatus.class)) {
            isValid = null != RetreatStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RetreatStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HangStatus.class)) {
            isValid = null != HangStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HangStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = null != SignForStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = null != ChargeUpStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = null != PaymentStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BlackStatus.class)) {
            isValid = null != BlackStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BlackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutStatus.class)) {
            isValid = null != TurnOutStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TurnOutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutType.class)) {
            isValid = null != TurnOutType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TurnOutType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = null != AuditStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataStatus.class)) {
            isValid = null != DataStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxRateType.class)) {
            isValid = null != TaxRateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxRateType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPreFlag.class)) {
            isValid = null != TaxPreFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxPreFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(DiscountFlag.class)) {
            isValid = null != DiscountFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DiscountFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = null != InvoiceColor.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceBusinessType.class)) {
            isValid = null != InvoiceBusinessType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceBusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(ErrorCode.class)) {
            isValid = null != ErrorCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ErrorCode.class.getSimpleName());
            }
        }
        if(clazz.equals(SendStatus.class)) {
            isValid = null != SendStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SendStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SendType.class)) {
            isValid = null != SendType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SendType.class.getSimpleName());
            }
        }
        if(clazz.equals(BackStatus.class)) {
            isValid = null != BackStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiveStatus.class)) {
            isValid = null != ReceiveStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceiveStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FileOrigin.class)) {
            isValid = null != FileOrigin.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FileOrigin.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyWay.class)) {
            isValid = null != VerifyWay.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VerifyWay.class.getSimpleName());
            }
        }
        if(clazz.equals(ProcessStatus.class)) {
            isValid = null != ProcessStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProcessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsOpen.class)) {
            isValid = null != IsOpen.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsOpen.class.getSimpleName());
            }
        }
        if(clazz.equals(ElSyncFlag.class)) {
            isValid = null != ElSyncFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ElSyncFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceCategory.class)) {
            isValid = null != InvoiceCategory.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(AreaType.class)) {
            isValid = null != AreaType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AreaType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsCancelCheck.class)) {
            isValid = null != IsCancelCheck.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsCancelCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(SaleConfirmStatus.class)) {
            isValid = null != SaleConfirmStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SaleConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReportStatus.class)) {
            isValid = null != ReportStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReportStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReimbursementStatus.class)) {
            isValid = null != ReimbursementStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReimbursementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedStatus.class)) {
            isValid = null != RedStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ManageStatus.class)) {
            isValid = null != ManageStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ManageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InspectStatus.class)) {
            isValid = null != InspectStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InspectStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpType.class)) {
            isValid = null != NcpType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpType.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpHandleType.class)) {
            isValid = null != NcpHandleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpHandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpHandleStatus.class)) {
            isValid = null != NcpHandleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EntryStatus.class)) {
            isValid = null != EntryStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EntryStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EntryTabStatus.class)) {
            isValid = null != EntryTabStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EntryTabStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpOperateType.class)) {
            isValid = null != NcpOperateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpOperateType.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpManageStatus.class)) {
            isValid = null != NcpManageStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpManageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoComplianceFlag.class)) {
            isValid = null != NoComplianceFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoComplianceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(NoComplianceType.class)) {
            isValid = null != NoComplianceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoComplianceType.class.getSimpleName());
            }
        }
        if(clazz.equals(NoComplianceLevel.class)) {
            isValid = null != NoComplianceLevel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoComplianceLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(FollowUpStatus.class)) {
            isValid = null != FollowUpStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FollowUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskHandleStatus.class)) {
            isValid = null != RiskHandleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RiskHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessControlStatus.class)) {
            isValid = null != BusinessControlStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessControlStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FunctionGroup.class)) {
            isValid = null != FunctionGroup.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FunctionGroup.class.getSimpleName());
            }
        }
        if(clazz.equals(FunctionGroupWay.class)) {
            isValid = null != FunctionGroupWay.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FunctionGroupWay.class.getSimpleName());
            }
        }
        if(clazz.equals(LogisticsStatus.class)) {
            isValid = null != LogisticsStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LogisticsStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(UnCertifiedReason.class)) {
            isValid = null != UnCertifiedReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UnCertifiedReason.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxIncentivesType.class)) {
            isValid = null != TaxIncentivesType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxIncentivesType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceExt30.class)) {
            isValid = null != InvoiceExt30.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceExt30.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceExt35.class)) {
            isValid = null != InvoiceExt35.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceExt35.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpJjkcAuthUse.class)) {
            isValid = null != NcpJjkcAuthUse.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpJjkcAuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpJjkcSubmitStatus.class)) {
            isValid = null != NcpJjkcSubmitStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpJjkcSubmitStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpJjkcStatus.class)) {
            isValid = null != NcpJjkcStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpJjkcStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsCancelledCheck.class)) {
            isValid = null != IsCancelledCheck.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsCancelledCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(OperateType.class)) {
            isValid = null != OperateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OperateType.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskInvoiceCategory.class)) {
            isValid = null != RiskInvoiceCategory.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RiskInvoiceCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthFlag.class)) {
            isValid = null != AuthFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(IsRepeat.class)) {
            isValid = null != IsRepeat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsRepeat.class.getSimpleName());
            }
        }
        if(clazz.equals(IsNeedAuth.class)) {
            isValid = null != IsNeedAuth.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsNeedAuth.class.getSimpleName());
            }
        }
        if(clazz.equals(IsSendException.class)) {
            isValid = null != IsSendException.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsSendException.class.getSimpleName());
            }
        }
        if(clazz.equals(ReturnType.class)) {
            isValid = null != ReturnType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReturnType.class.getSimpleName());
            }
        }
        if(clazz.equals(ReturnBatch.class)) {
            isValid = null != ReturnBatch.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReturnBatch.class.getSimpleName());
            }
        }
        if(clazz.equals(NeedExpress.class)) {
            isValid = null != NeedExpress.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NeedExpress.class.getSimpleName());
            }
        }
        if(clazz.equals(IsTaxCancelAuth.class)) {
            isValid = null != IsTaxCancelAuth.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsTaxCancelAuth.class.getSimpleName());
            }
        }
        if(clazz.equals(ActualAuthWay.class)) {
            isValid = null != ActualAuthWay.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ActualAuthWay.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogDeleteWay.class)) {
            isValid = null != RecogDeleteWay.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecogDeleteWay.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogBusinessType.class)) {
            isValid = null != RecogBusinessType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecogBusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogDeleteRemark.class)) {
            isValid = null != RecogDeleteRemark.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecogDeleteRemark.class.getSimpleName());
            }
        }
        if(clazz.equals(IsLegalSynergetics.class)) {
            isValid = null != IsLegalSynergetics.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsLegalSynergetics.class.getSimpleName());
            }
        }
        if(clazz.equals(IsCheck.class)) {
            isValid = null != IsCheck.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(Bookkeeping.class)) {
            isValid = null != Bookkeeping.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Bookkeeping.class.getSimpleName());
            }
        }
        if(clazz.equals(WithholdingAuthUse.class)) {
            isValid = null != WithholdingAuthUse.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WithholdingAuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(WithholdingOperationType.class)) {
            isValid = null != WithholdingOperationType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WithholdingOperationType.class.getSimpleName());
            }
        }
        if(clazz.equals(ElFlag.class)) {
            isValid = null != ElFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ElFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoicePoolSystemType.class)) {
            isValid = null != InvoicePoolSystemType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoicePoolSystemType.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext26.class)) {
            isValid = null != Ext26.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext26.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerIssuedStatus.class)) {
            isValid = null != SellerIssuedStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SellerIssuedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxRateDefinition.class)) {
            isValid = null != TaxRateDefinition.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxRateDefinition.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext6.class)) {
            isValid = null != Ext6.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext6.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemSource.class)) {
            isValid = null != SystemSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SystemSource.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext4.class)) {
            isValid = null != Ext4.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext4.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogWay.class)) {
            isValid = null != RecogWay.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecogWay.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext2.class)) {
            isValid = null != Ext2.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext2.class.getSimpleName());
            }
        }
        if(clazz.equals(ShowStatus.class)) {
            isValid = null != ShowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ShowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskStatus.class)) {
            isValid = null != RiskStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RiskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TransferStatus.class)) {
            isValid = null != TransferStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TransferStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ExistFlag.class)) {
            isValid = null != ExistFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExistFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(Satisfy.class)) {
            isValid = null != Satisfy.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Satisfy.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchSendStatus.class)) {
            isValid = null != MatchSendStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchSendStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ExceptionStatus.class)) {
            isValid = null != ExceptionStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExceptionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStyle.class)) {
            isValid = null != MatchStyle.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStyle.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchDataSource.class)) {
            isValid = null != MatchDataSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchDataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessModule.class)) {
            isValid = null != BusinessModule.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessModule.class.getSimpleName());
            }
        }
        if(clazz.equals(FunctionCode.class)) {
            isValid = null != FunctionCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FunctionCode.class.getSimpleName());
            }
        }
        if(clazz.equals(Standard.class)) {
            isValid = null != Standard.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Standard.class.getSimpleName());
            }
        }
        if(clazz.equals(Dimension.class)) {
            isValid = null != Dimension.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Dimension.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceCheckTabFlag.class)) {
            isValid = null != InvoiceCheckTabFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceCheckTabFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceDrawbackCheckTabFlag.class)) {
            isValid = null != InvoiceDrawbackCheckTabFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceDrawbackCheckTabFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(CustomsPaymentCheckTabFlag.class)) {
            isValid = null != CustomsPaymentCheckTabFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CustomsPaymentCheckTabFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(CustomsPaymentDrawbackCheckTabFlag.class)) {
            isValid = null != CustomsPaymentDrawbackCheckTabFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CustomsPaymentDrawbackCheckTabFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceOfflineCheckTabFlag.class)) {
            isValid = null != InvoiceOfflineCheckTabFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceOfflineCheckTabFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceMethod.class)) {
            isValid = null != PriceMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PriceMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(BizMakeoutStatus.class)) {
            isValid = null != BizMakeoutStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizMakeoutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CrossCitySign.class)) {
            isValid = null != CrossCitySign.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CrossCitySign.class.getSimpleName());
            }
        }
        if(clazz.equals(TypeOfVehicle.class)) {
            isValid = null != TypeOfVehicle.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TypeOfVehicle.class.getSimpleName());
            }
        }
        if(clazz.equals(TransportToolType.class)) {
            isValid = null != TransportToolType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TransportToolType.class.getSimpleName());
            }
        }
        if(clazz.equals(AreaUnit.class)) {
            isValid = null != AreaUnit.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AreaUnit.class.getSimpleName());
            }
        }
        if(clazz.equals(SenseWordLevel.class)) {
            isValid = null != SenseWordLevel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SenseWordLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(PurCompanyExceptionContent.class)) {
            isValid = null != PurCompanyExceptionContent.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PurCompanyExceptionContent.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceCheckedTabFlag.class)) {
            isValid = null != InvoiceCheckedTabFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceCheckedTabFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceDrawbackCheckedTabFlag.class)) {
            isValid = null != InvoiceDrawbackCheckedTabFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceDrawbackCheckedTabFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(CustomsPaymentCheckedTabFlag.class)) {
            isValid = null != CustomsPaymentCheckedTabFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CustomsPaymentCheckedTabFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(CustomsPaymentDrawbackCheckedTabFlag.class)) {
            isValid = null != CustomsPaymentDrawbackCheckedTabFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CustomsPaymentDrawbackCheckedTabFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(OriginFileType.class)) {
            isValid = null != OriginFileType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OriginFileType.class.getSimpleName());
            }
        }
        if(clazz.equals(ExtGMRY.class)) {
            isValid = null != ExtGMRY.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExtGMRY.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext9Wilmar.class)) {
            isValid = null != Ext9Wilmar.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext9Wilmar.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext3Wilmar.class)) {
            isValid = null != Ext3Wilmar.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext3Wilmar.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext8Wilmar.class)) {
            isValid = null != Ext8Wilmar.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext8Wilmar.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext13Wilmar.class)) {
            isValid = null != Ext13Wilmar.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext13Wilmar.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext17Wilmar.class)) {
            isValid = null != Ext17Wilmar.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext17Wilmar.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext25Wilmar.class)) {
            isValid = null != Ext25Wilmar.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext25Wilmar.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext19Wilmar.class)) {
            isValid = null != Ext19Wilmar.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext19Wilmar.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext20Wilmar.class)) {
            isValid = null != Ext20Wilmar.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext20Wilmar.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext23Wilmar.class)) {
            isValid = null != Ext23Wilmar.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext23Wilmar.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessTagMcdonalds.class)) {
            isValid = null != BusinessTagMcdonalds.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessTagMcdonalds.class.getSimpleName());
            }
        }
        if(clazz.equals(Ext1Mcdonalds.class)) {
            isValid = null != Ext1Mcdonalds.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Ext1Mcdonalds.class.getSimpleName());
            }
        }
        if(clazz.equals(BizTag1JKL.class)) {
            isValid = null != BizTag1JKL.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizTag1JKL.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
