package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * error_code
 * </p>
 *
 * @author ultraman
 * @since 2024-04-12
 */
public enum ErrorCode {

    INVALIDATE_INVOICE_CODE("invalidate_invoice_code", "无效的发票代码");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErrorCode fromCode(String code) {
        return Stream.of(ErrorCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
