package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ext2
 * </p>
 *
 * @author ultraman
 * @since 2024-04-12
 */
public enum Ext2 {

    _1001("1001", "1001-上海中央仓库"),
    _1002("1002", "1002-上海进口仓库"),
    _1003("1003", "1003-广州仓库"),
    _1004("1004", "1004-深圳仓库"),
    _1005("1005", "1005-北京仓库"),
    _1006("1006", "1006-西区转运仓"),
    _1010("1010", "1010-上海普陀商场"),
    _1011("1011", "1011-无锡锡山商场"),
    _1012("1012", "1012-上海闵行商场"),
    _1013("1013", "1013-宁波鄞州商场"),
    _1014("1014", "1014-南京雨花商场"),
    _1016("1016", "1016-福州仓山商场"),
    _1017("1017", "1017-上海浦东商场"),
    _1019("1019", "1019-武汉硚口商场"),
    _1020("1020", "1020-青岛四方商场"),
    _1021("1021", "1021-大连西岗商场"),
    _1022("1022", "1022-重庆南岸商场"),
    _1023("1023", "1023-武汉洪山商场"),
    _1024("1024", "1024-成都青羊商场"),
    _1025("1025", "1025-长沙开福商场"),
    _1026("1026", "1026-天津红桥商场"),
    _1027("1027", "1027-西安雁塔商场"),
    _1028("1028", "1028-厦门湖里商场"),
    _1029("1029", "1029-东莞万江商场"),
    _1030("1030", "1030-深圳罗湖商场"),
    _1031("1031", "1031-北京十里河分公司"),
    _1033("1033", "1033-沈阳铁西商场"),
    _1034("1034", "1034-广州天河商场"),
    _1035("1035", "1035-哈尔滨道里商场"),
    _1036("1036", "1036-广州白云商场"),
    _1038("1038", "1038-合肥包河商场"),
    _1039("1039", "1039-郑州郑东商场"),
    _1040("1040", "1040-常熟商场"),
    _1041("1041", "1041-苏州高新区商场"),
    _1042("1042", "1042-杭州金家渡商场"),
    _1043("1043", "1043-广州花都商场"),
    _1044("1044", "1044-上海嘉定商场"),
    _1047("1047", "1047-深圳南山商场"),
    _1049("1049", "1049-昆明北辰商场"),
    _1050("1050", "1050-嘉兴经济开发区商场"),
    _1051("1051", "1051-南昌青山湖商场"),
    _1052("1052", "1052-北京草桥东路分公司"),
    _1053("1053", "1053-泉州丰泽商场"),
    _1054("1054", "1054-苏州吴中商场"),
    _1055("1055", "1055-南通崇川分公司"),
    _1056("1056", "1056-长春净月商场"),
    _1058("1058", "1058-银川兴庆商场"),
    _1059("1059", "1059-黄岛商场"),
    _1060("1060", "1060-昆山商场"),
    _1061("1061", "1061-中山西区商场"),
    _1062("1062", "1062-常州天宁商场"),
    _1063("1063", "1063-深圳宝安商场"),
    _1066("1066", "1066-江阴商场"),
    _1067("1067", "1067-张家港商场"),
    _1068("1068", "1068-扬州邗江商场"),
    _1069("1069", "1069-重庆两江新区商场"),
    _1070("1070", "1070-宁波海曙商场"),
    _1071("1071", "1071-麦德龙（烟台）商业有限公司"),
    _1072("1072", "1072-南京下关商场"),
    _1074("1074", "1074-慈溪商场"),
    _1076("1076", "1076-无锡惠山商场"),
    _1079("1079", "1079-淘宝商城商场"),
    _4080("4080", "4080-西安麦德龙商贸有限公司"),
    _1090("1090", "1090-中国总部"),
    _1105("1105", "1105-宜兴商场"),
    _1108("1108", "1108-北京立水桥分公司"),
    _1109("1109", "1109-沈阳浑南分公司"),
    _1121("1121", "1121-淄博张店商场"),
    _1123("1123", "1123-潍坊商场"),
    _1124("1124", "1124-株洲商场"),
    _1125("1125", "1125-台州椒江商场"),
    _1127("1127", "1127-徐州开发区商场"),
    _1128("1128", "1128-成都高新商场"),
    _1130("1130", "1130-盐城盐都分公司"),
    _1132("1132", "1132-广州番禺商场"),
    _1134("1134", "1134-宜昌西陵商场"),
    _1139("1139", "1139-上海金山商场"),
    _1141("1141", "1141-淮安深圳东路商场"),
    _1142("1142", "1142-绍兴商场"),
    _1144("1144", "1144-襄阳高新区商场"),
    _1149("1149", "1149-南昌红谷商场"),
    _1158("1158", "1158-莆田荔城商场"),
    _1159("1159", "1159-武汉汉阳商场"),
    _1160("1160", "1160-临沂罗庄商场"),
    _1161("1161", "1161-长春宽城商场"),
    _1163("1163", "1163-芜湖弋江商场"),
    _1164("1164", "1164-镇江开发区商场"),
    _1165("1165", "1165-昆明广福商场"),
    _1172("1172", "1172-重庆九龙坡商场"),
    _1173("1173", "1173-上海青浦商场"),
    _1179("1179", "1179-常州武进商场"),
    _1191("1191", "1191-九江商场"),
    _1196("1196", "1196-贵阳云岩商场"),
    _1198("1198", "1198-上海松江商场"),
    _1202("1202", "1202-天津滨海新区商场"),
    _1210("1210", "1210-成都锦江商场"),
    _1216("1216", "1216-武汉盘龙商场"),
    _1217("1217", "1217-长沙天心商场"),
    _1219("1219", "1219-济南槐荫商场"),
    _1222("1222", "1222-重庆沙坪坝商场"),
    _1225("1225", "1225-长沙岳麓商场"),
    _1228("1228", "1228-德阳商场"),
    _1229("1229", "1229-上海虹口江湾商场"),
    _1230("1230", "1230-兰州七里河分公司"),
    _1233("1233", "1233-三河燕郊神威北路分公司"),
    _1234("1234", "1234-马鞍山花山区分公司"),
    _1235("1235", "1235-上海沪太路店"),
    _1236("1236", "1236-北京杏石口分公司"),
    _1237("1237", "1237-北京大成路分公司"),
    _1600("1600", "1600-电商外仓商场"),
    _1601("1601", "1601-虚拟店601"),
    _1610("1610", "1610-总部便利店"),
    _2162("2162", "2162-麦咨达(上海)"),
    _1471("1471", "1471-烟台芝罘商场");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Ext2(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Ext2 fromCode(String code) {
        return Stream.of(Ext2.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
